//
//  YHServiceItemCell.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceItemCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHServiceItemCell"

    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 13)
        label.textColor = .mainTextColor
        label.textAlignment = .center
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateItem(_ item: YHServiceItem) {
        titleLabel.text = item.name
        
        if item.isSelect {
            self.layer.borderWidth = 1.0
            self.layer.borderColor = UIColor.brandMainColor.cgColor
            titleLabel.textColor = UIColor.brandMainColor
            
        } else {
            self.layer.borderWidth = 0.0
            self.layer.borderColor = nil
            titleLabel.textColor = UIColor.mainTextColor
        }
    }
    
    func createUI() {
        
        self.layer.cornerRadius = kCornerRadius3
        self.backgroundColor = UIColor.init(hex: 0xF4F6FA)

        self.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
